<?php
$page_title = 'مدیریت Tagها';
require __DIR__ . '/_init.php';

$action = $_POST['action'] ?? '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if ($action === 'create') {
    $name = trim((string)($_POST['name'] ?? ''));
    if ($name !== '') {
      $st = $pdo->prepare("INSERT IGNORE INTO tags(name) VALUES(?)");
      $st->execute([$name]);
      flash_set('ok','Tag اضافه شد.');
    }
    header('Location: tags.php'); exit;
  }
  if ($action === 'delete') {
    $id = (int)($_POST['id'] ?? 0);
    if ($id>0) {
      $pdo->prepare("DELETE FROM tags WHERE id=?")->execute([$id]);
      flash_set('ok','Tag حذف شد.');
    }
    header('Location: tags.php'); exit;
  }
}

$tags = $pdo->query("SELECT t.*, (SELECT COUNT(*) FROM company_tags ct WHERE ct.tag_id=t.id) as usage_count
                     FROM tags t ORDER BY t.name ASC")->fetchAll();

$ok = flash_get('ok');
require __DIR__ . '/_layout_top.php';
?>
<div class="p-card">
  <h3>افزودن Tag جدید</h3>
  <?php if($ok): ?><div class="p-badge p-badge--ok"><?= h($ok) ?></div><?php endif; ?>
  <form method="post" class="p-row" style="margin-top:10px">
    <input type="hidden" name="action" value="create">
    <input class="p-input" name="name" placeholder="مثال: حفاری / پتروشیمی / تجهیزات" required>
    <button class="p-btn p-btn--primary" type="submit">ثبت</button>
  </form>
  <div class="p-help">این Tagها در مدیریت شرکت‌ها و پیشنهاد شرکت‌های مرتبط استفاده می‌شوند.</div>
</div>

<div class="p-card">
  <h3>لیست Tagها</h3>
  <table class="p-table">
    <thead><tr><th>Tag</th><th>تعداد شرکت</th><th></th></tr></thead>
    <tbody>
      <?php foreach($tags as $t): ?>
        <tr>
          <td><?= h($t['name']) ?></td>
          <td><span class="p-pill"><?= (int)$t['usage_count'] ?></span></td>
          <td style="width:120px">
            <form method="post" onsubmit="return confirm('حذف شود؟');">
              <input type="hidden" name="action" value="delete">
              <input type="hidden" name="id" value="<?= (int)$t['id'] ?>">
              <button class="p-btn p-btn--danger" type="submit">حذف</button>
            </form>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?php require __DIR__ . '/_layout_bottom.php'; ?>
