<?php
$page_title='تنظیمات سیستم';
require __DIR__.'/_init.php';

if($_SERVER['REQUEST_METHOD']==='POST'){
  foreach(['openrouter_api_key','openrouter_model','system_prompt','response_rules','sitemap_url','ai_enabled'] as $k){
    if(isset($_POST[$k])){
      $v = is_array($_POST[$k]) ? json_encode($_POST[$k]) : (string)$_POST[$k];
      setting_set($pdo,$k,$v);
    }
  }
  flash_set('ok','تنظیمات ذخیره شد.');
  header('Location: settings.php'); exit;
}

$vals = [
  'openrouter_api_key'=>setting_get($pdo,'openrouter_api_key',''),
  'openrouter_model'=>setting_get($pdo,'openrouter_model','google/gemma-2-9b-it'),
  'system_prompt'=>setting_get($pdo,'system_prompt',''),
  'response_rules'=>setting_get($pdo,'response_rules',''),
  'sitemap_url'=>setting_get($pdo,'sitemap_url','https://oilshow-khz.com/sitemap_index.xml'),
  'ai_enabled'=>setting_get($pdo,'ai_enabled','1'),
];

$ok=flash_get('ok');
require __DIR__.'/_layout_top.php';
?>
<div class="p-card">
<h3>تنظیمات AI و سیستم</h3>
<?php if($ok): ?><div class="p-badge p-badge--ok"><?=h($ok)?></div><?php endif; ?>
<form method="post">
  <div class="p-grid2">
    <div>
      <div class="p-label">OpenRouter API Key</div>
      <input class="p-input" name="openrouter_api_key" value="<?=h($vals['openrouter_api_key'])?>">
    </div>
    <div>
      <div class="p-label">Model</div>
      <input class="p-input" name="openrouter_model" value="<?=h($vals['openrouter_model'])?>">
    </div>
  </div>
  <div class="p-label">System Prompt</div>
  <textarea class="p-textarea" name="system_prompt"><?=h($vals['system_prompt'])?></textarea>
  <div class="p-label">Response Rules</div>
  <textarea class="p-textarea" name="response_rules"><?=h($vals['response_rules'])?></textarea>
  <div class="p-grid2">
    <div>
      <div class="p-label">Sitemap URL</div>
      <input class="p-input" name="sitemap_url" value="<?=h($vals['sitemap_url'])?>">
    </div>
    <div>
      <div class="p-label">AI فعال</div>
      <select class="p-select" name="ai_enabled">
        <option value="1" <?=$vals['ai_enabled']=='1'?'selected':''?>>روشن</option>
        <option value="0" <?=$vals['ai_enabled']=='0'?'selected':''?>>خاموش</option>
      </select>
    </div>
  </div>
  <div class="p-hr"></div>
  <button class="p-btn p-btn--primary" type="submit">ذخیره</button>
</form>
</div>
<?php require __DIR__.'/_layout_bottom.php'; ?>
