<?php
$page_title='لاگ‌ها';
require __DIR__.'/_init.php';

$from = trim((string)($_GET['from'] ?? ''));
$to   = trim((string)($_GET['to'] ?? ''));
$source = trim((string)($_GET['source'] ?? ''));
if ($from==='') $from = date('Y-m-d', strtotime('-7 days')).' 00:00:00';
if ($to==='')   $to   = date('Y-m-d').' 23:59:59';
if (preg_match('/^\d{4}-\d{2}-\d{2}$/',$from)) $from .= ' 00:00:00';
if (preg_match('/^\d{4}-\d{2}-\d{2}$/',$to))   $to   .= ' 23:59:59';

$where = "WHERE l.created_at BETWEEN ? AND ?";
$params = [$from,$to];
if ($source !== '') {
  $where .= " AND l.source=?";
  $params[] = $source;
}

$st = $pdo->prepare("SELECT l.*, c.name company_name
  FROM chat_logs l
  LEFT JOIN companies c ON c.id=l.company_id
  $where
  ORDER BY l.id DESC
  LIMIT 200");
$st->execute($params);
$rows = $st->fetchAll();

require __DIR__.'/_layout_top.php';
?>
<div class="p-card">
  <h3>فیلتر</h3>
  <form class="p-row" method="get">
    <input class="p-input" style="max-width:220px" name="from" value="<?=h($from)?>">
    <input class="p-input" style="max-width:220px" name="to" value="<?=h($to)?>">
    <select class="p-select" name="source" style="max-width:180px">
      <option value="">همه منابع</option>
      <?php foreach(['faq','company','site','ai','none'] as $s): ?>
        <option value="<?=$s?>" <?=$source===$s?'selected':''?>><?=$s?></option>
      <?php endforeach; ?>
    </select>
    <button class="p-btn p-btn--primary">اعمال</button>
    <a class="p-btn" href="logs.php">۷ روز اخیر</a>
  </form>
  <div class="p-help">آخرین ۲۰۰ لاگ نمایش داده می‌شود.</div>
</div>

<div class="p-card">
  <h3>لاگ‌ها</h3>
  <table class="p-table">
    <thead><tr><th>زمان</th><th>سؤال</th><th>منبع</th><th>شرکت</th><th>IP</th></tr></thead>
    <tbody>
      <?php foreach($rows as $x): ?>
        <tr>
          <td><small><?=h($x['created_at'])?></small></td>
          <td><?=h($x['question'])?></td>
          <td><span class="p-pill"><?=h($x['source'] ?: '—')?></span></td>
          <td><?=h($x['company_name'] ?: '—')?></td>
          <td><small><?=h($x['ip'] ?: '—')?></small></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?php require __DIR__.'/_layout_bottom.php'; ?>
