<?php
$page_title='FAQ';
require __DIR__.'/_init.php';

$action=$_POST['action']??'';
if($_SERVER['REQUEST_METHOD']==='POST'){
  if($action==='save'){
    $id=(int)($_POST['id']??0);
    $data=[
      $_POST['question']??'',
      $_POST['answer']??'',
      $_POST['keywords']??'',
      (int)($_POST['priority']??0),
      isset($_POST['is_active'])?1:0
    ];
    if($id>0){
      $st=$pdo->prepare("UPDATE faq SET question=?,answer=?,keywords=?,priority=?,is_active=? WHERE id=?");
      $st->execute([...$data,$id]);
    }else{
      $st=$pdo->prepare("INSERT INTO faq(question,answer,keywords,priority,is_active) VALUES(?,?,?,?,?)");
      $st->execute($data);
    }
    flash_set('ok','ذخیره شد.');
    header('Location: faq.php'); exit;
  }
  if($action==='delete'){
    $id=(int)($_POST['id']??0);
    if($id>0) $pdo->prepare("DELETE FROM faq WHERE id=?")->execute([$id]);
    flash_set('ok','حذف شد.');
    header('Location: faq.php'); exit;
  }
}

$rows=$pdo->query("SELECT * FROM faq ORDER BY priority DESC,id DESC")->fetchAll();
$ok=flash_get('ok');
require __DIR__.'/_layout_top.php';
?>
<div class="p-card">
<h3>افزودن FAQ</h3>
<?php if($ok):?><div class="p-badge p-badge--ok"><?=h($ok)?></div><?php endif;?>
<form method="post">
<input type="hidden" name="action" value="save">
<div class="p-label">سؤال</div><input class="p-input" name="question" required>
<div class="p-label">پاسخ</div><textarea class="p-textarea" name="answer" required></textarea>
<div class="p-grid2">
  <div><div class="p-label">کلیدواژه</div><input class="p-input" name="keywords"></div>
  <div><div class="p-label">اولویت</div><input class="p-input" type="number" name="priority" value="0"></div>
</div>
<label class="p-row"><input type="checkbox" name="is_active" checked> فعال</label>
<button class="p-btn p-btn--primary" type="submit">ثبت</button>
</form>
</div>

<div class="p-card">
<h3>لیست FAQ</h3>
<table class="p-table">
<thead><tr><th>سؤال</th><th>اولویت</th><th>فعال</th><th></th></tr></thead>
<tbody>
<?php foreach($rows as $r):?>
<tr>
<td><?=h($r['question'])?></td>
<td><?= (int)$r['priority']?></td>
<td><?= $r['is_active']?'✔':'—'?></td>
<td>
<form method="post" onsubmit="return confirm('حذف شود؟');">
<input type="hidden" name="action" value="delete">
<input type="hidden" name="id" value="<?= (int)$r['id']?>">
<button class="p-btn p-btn--danger">حذف</button>
</form>
</td>
</tr>
<?php endforeach;?>
</tbody></table>
</div>
<?php require __DIR__.'/_layout_bottom.php'; ?>
