<?php
function enforce_rate_limit(PDO $pdo, array $app): void {
  $ip  = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
  $max = (int)($app['rate_limit']['max_requests'] ?? 30);
  $win = (int)($app['rate_limit']['window_seconds'] ?? 300);
  if ($win <= 0) $win = 300;
  if ($max <= 0) $max = 30;

  // Ensure table exists (idempotent)
  $pdo->exec("CREATE TABLE IF NOT EXISTS rate_limits (
    ip VARCHAR(45) NOT NULL PRIMARY KEY,
    hits INT NOT NULL DEFAULT 0,
    window_start DATETIME NOT NULL,
    updated_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    KEY idx_window_start (window_start)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

  // IMPORTANT: MySQL/MariaDB doesn't like binding INTERVAL values
  $pdo->exec("DELETE FROM rate_limits WHERE window_start < (NOW() - INTERVAL {$win} SECOND)");

  $st = $pdo->prepare("SELECT hits FROM rate_limits WHERE ip=? LIMIT 1");
  $st->execute([$ip]);
  $hits = $st->fetchColumn();

  if ($hits === false) {
    $pdo->prepare("INSERT INTO rate_limits(ip,hits,window_start) VALUES(?,1,NOW())")->execute([$ip]);
    return;
  }

  if ((int)$hits >= $max) {
    http_response_code(429);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
      'error' => 'rate_limited',
      'message' => '⚠️ تعداد درخواست‌ها زیاد است. چند دقیقه بعد دوباره تلاش کنید.'
    ], JSON_UNESCAPED_UNICODE);
    exit;
  }

  $pdo->prepare("UPDATE rate_limits SET hits=hits+1 WHERE ip=?")->execute([$ip]);
}
