<?php
function format_rich(string $title, string $summary, array $bullets=[], string $extra=''): string {
  $out = "🎯 {$title}\n\n";
  if (trim($summary) !== '') $out .= "✅ " . trim($summary) . "\n\n";
  foreach ($bullets as $b) {
    $b = trim($b);
    if ($b==='') continue;
    $out .= "• {$b}\n";
  }
  if (trim($extra) !== '') {
    $out .= "\n📌 اطلاعات تکمیلی:\n" . trim($extra);
  }
  return trim($out);
}
