<?php
$app = require __DIR__ . '/../config/app.php';
$db  = require __DIR__ . '/../config/db.php';

try {
  $dsn = "mysql:host={$db['host']};dbname={$db['name']};charset={$db['charset']}";
  $pdo = new PDO($dsn, $db['user'], $db['pass'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  ]);
} catch (Exception $e) {
  http_response_code(500);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode(['error' => 'Database connection failed'], JSON_UNESCAPED_UNICODE);
  exit;
}

function setting_get(PDO $pdo, string $key, string $default=''): string {
  $st = $pdo->prepare("SELECT value FROM settings WHERE `key`=? LIMIT 1");
  $st->execute([$key]);
  $row = $st->fetch();
  return $row ? (string)$row['value'] : $default;
}
function setting_set(PDO $pdo, string $key, string $value): void {
  $st = $pdo->prepare("INSERT INTO settings(`key`,`value`) VALUES(?,?) ON DUPLICATE KEY UPDATE value=VALUES(value)");
  $st->execute([$key, $value]);
}
