const log = document.getElementById('log');
const q = document.getElementById('q');
const btn = document.getElementById('send');

function autoResize(){
  q.style.height = 'auto';
  q.style.height = Math.min(q.scrollHeight, 140) + 'px';
}
q.addEventListener('input', autoResize);

function addBubble(text, who, meta=''){
  const row = document.createElement('div');
  row.className = 'row ' + (who === 'me' ? 'me' : 'bot');

  const bubble = document.createElement('div');
  bubble.className = 'bubble';
  bubble.textContent = text;

  row.appendChild(bubble);

  if(meta){
    const m = document.createElement('div');
    m.className = 'meta';
    m.textContent = meta;
    row.appendChild(m);
  }

  log.appendChild(row);
  log.scrollTop = log.scrollHeight;
  return row;
}

let typingRow = null;
function showTyping(){
  if(typingRow) return;
  typingRow = document.createElement('div');
  typingRow.className = 'row bot';
  const b = document.createElement('div');
  b.className = 'bubble';
  const t = document.createElement('div');
  t.className = 'typing';
  t.innerHTML = '<span style="opacity:.85">دستیار در حال بررسی اطلاعات…</span><span class="dot"></span><span class="dot"></span><span class="dot"></span>';
  b.appendChild(t);
  typingRow.appendChild(b);
  log.appendChild(typingRow);
  log.scrollTop = log.scrollHeight;
}
function hideTyping(){
  if(!typingRow) return;
  typingRow.remove();
  typingRow = null;
}

async function ask(){
  const text = q.value.trim();
  if(!text) return;

  addBubble(text, 'me');
  q.value = '';
  autoResize();
  btn.disabled = true;
  q.disabled = true;

  showTyping();

  try{
    const r = await fetch('../api/chat.php', {
      method:'POST',
      headers:{'Content-Type':'application/json'},
      body: JSON.stringify({question:text})
    });
    const data = await r.json();
    hideTyping();
    addBubble(data.answer || '—', 'bot', data?.meta?.source ? ('منبع: ' + data.meta.source) : '');
  }catch(e){
    hideTyping();
    addBubble('متأسفانه ارتباط با سرور مشکل داشت. دوباره تلاش کن.', 'bot');
  }finally{
    btn.disabled = false;
    q.disabled = false;
    q.focus();
  }
}

btn.addEventListener('click', ask);

// Enter to send, Shift+Enter for newline
q.addEventListener('keydown', (e) => {
  if (e.key === 'Enter' && !e.shiftKey) {
    e.preventDefault();
    ask();
  }
});

addBubble('سلام! 👋\nاسم شرکت، حوزه فعالیت یا شماره غرفه رو بنویس تا سریع راهنمایی‌ات کنم.', 'bot');
q.focus();
